/* - LEDDetachListener -
 * We'll clear all our fields and disable all the editable fields to 
 * prevent errors
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.LEDPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class LEDDetachListener implements DetachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numLEDTxt;
    private JComboBox ledCmb;
    private JSlider ledBrightScrl;
    private JComboBox voltageCmb;
    private JComboBox currentLimitCmb;
    private JLabel voltageLbl;
    private JLabel currentLimitLbl;
    
    /** Creates a new instance of LEDDetachListener */
    public LEDDetachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numLEDTxt, 
            JComboBox ledCmb, JSlider ledBrightScrl, JComboBox voltageCmb, 
            JComboBox currentLimitCmb, JLabel voltageLbl, JLabel currentLimitLbl)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numLEDTxt = numLEDTxt;
        this.ledCmb = ledCmb;
        this.ledBrightScrl = ledBrightScrl;
        this.voltageCmb = voltageCmb;
        this.currentLimitCmb = currentLimitCmb;
        this.voltageLbl = voltageLbl;
        this.currentLimitLbl = currentLimitLbl;
    }

    public void detached(DetachEvent de)
    {
        try
        {
            LEDPhidget detached = (LEDPhidget)de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numLEDTxt.setText("");
            
            ledCmb.setEnabled(false);
            ledCmb.removeAllItems();
            ledBrightScrl.setEnabled(false);
            
            voltageLbl.setVisible(false);
            voltageCmb.setEnabled(false);
            voltageCmb.setVisible(false);
            
            currentLimitLbl.setVisible(false);
            currentLimitCmb.setEnabled(false);
            currentLimitCmb.setVisible(false);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
